'
' Egzemplarze tej klasy otrzymuj powiadomienia od obiektu, ktry moe si
' komunikowa w tym trybie wycznie z obiektami klas implementujcych
' interfejs ISecurityObserver, i przekazuje te powiadomienia do obiektu
' klasy SecurityMonitor, ktra nie implementuje interfejsu ISecurityObserver.
'
Public Class SecurityAdapter
    Implements ISecurityObserver

    Private sm As SecurityMonitor

    ' Konstruktor
    Public Sub New(ByVal sm As SecurityMonitor)
        Me.sm = sm
    End Sub 'New

    '
    ' Metoda Notify jest wywoywana celem dostarczenia powiadomienia o zdarzeniu
    ' zwizanym z bezpieczestwem do tego obiektu.
    '
    ' d  Liczba liczba identyfikujca urzdzenie bdce oryginalnym rdem zdarzenia, ktre
    '     jest przedmiotem tego powiadomienia.
    ' e  Rodzaj rodzaj zdarzenia zwizanego z bezpieczestwem, ktrego wystpienie byo
    '     powodem wygenerowania tego powiadomienia.
    '
    Public Sub Notify(ByVal d As Integer, ByVal e As SecurityCondition) _
     Implements SecurityObserver.Notify
        Select Case e
            Case SecurityCondition.Alarm
                sm.SecurityAlert(d)
            Case SecurityCondition.Diagnostic, _
                SecurityCondition.LowPower
                sm.DiagnosticAlert(d)
        End Select
    End Sub
End Class 'SecurityAdapter
